from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math
import TestHaz


class BoxArena(Arenas.SuperArena):
    "Battle it out atop this volcanic island. Keep to high ground, or you'll get consumed by the lava as the island sinks!"
    name = "DSL Lava Island Arena"
    preview = "DSLLavaArena/DSLLavaArena.bmp"
    game_types = ['OBSTACLE COURSE']
    extent = (-16, 16, 20, -20)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/DSLLavaArena/DSLLavaArena.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        fmod = 0.015
        degrad = 0.01745
        self.AddStaticCamera("Static 1", (10.8, 6.6, -17.04), (.367, -40*degrad), degrad*55)
        self.AddStaticCamera("Static 2", (0, 28.8, 0), (90*degrad, 90*degrad), degrad*37)
        self.AddStaticCamera("Static 3", (0, 7.8, -18), (40*degrad, 0), degrad*62)

	self.AddWatchCamera("Watch Cam 1", (-24, 15, 18), (12, 20, 30*degrad, 20*degrad))
	self.AddWatchCamera("Watch Cam 2", (24, 15, -18), (12, 20, 30*degrad, 20*degrad))
	self.AddWatchCamera("Watch Cam 3", (10, 20, 10), (14, 22, 30*degrad, 30*degrad))
	self.AddWatchCamera("Watch Cam 4", (-10, 20, -10), (16, 24, 30*degrad, 40*degrad))
	
        self.players = ()
	self.platimer = 0

        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        #Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.051,1.83754), (-12.4182,0.051,12.4283), (-12.4182,0.051,1.83754))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-8.17686,0.051,12.4283), (-12.4182,0.051,12.4283))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-12.4182,0.051,12.4283), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.25999,0.051,12.4283), (-2.49123,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (2.25999,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((12.413,0.051,12.4283), (7.93297,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,1.91641), (12.413,0.051,12.4283))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (12.413,0.051,-12.4279), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (12.413,0.051,-12.4279), (12.413,0.051,-1.93329))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (8.17711,0.051,-12.4279), (12.413,0.051,-12.4279))
        self.AddShadowTriangle((-2.26871,0.051,-12.4279), (2.49519,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (-2.26871,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-12.4182,0.051,-12.4279), (-7.93688,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-1.8361), (-12.4182,0.051,-12.4279))
        self.AddShadowTriangle((-2.49123,0.051,9.91855), (-8.17686,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.49519,0.051,-9.92447), (8.17711,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (-10.2877,0.051,-1.8361), (-2.26871,0.051,-9.92447))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (7.93297,0.051,9.91855), (2.25999,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (-2.49123,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (2.25999,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (10.2878,0.051,1.91641), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (10.2878,0.051,-1.93329), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (2.49519,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-7.93688,0.051,-9.92447), (-2.26871,0.051,-9.92447))
        
    def HazardsOn(self, on):

        self.lava1 = self.GetHinge("Hinge01")
        self.lava1.SetAutoLocks(False, True)
        self.lava1.SetPowerSettings(2, 10000)
        self.lava1.Lock(False)
        self.lava1.SetDirection(-100)
            
        self.lava2 = self.GetHinge("Hinge02")
        self.lava2.SetAutoLocks(False, True)
        self.lava2.SetPowerSettings(2, 10000)
        self.lava2.Lock(False)
        self.lava2.SetDirection(100)

        prism = self.AddPrismatic("arena_collision", "step01", 0, 1, 0, 1.0, -30.0, 0)
        self.block1 = TestHaz.Faller(prism, (0.0, 0.0, -19.5))
        self.AddHazard(self.block1)
        prism = self.AddPrismatic("arena_collision", "step02", 0, 1, 0, 1.0, -30.0, 0)
        self.block2 = TestHaz.Faller(prism, (0.0, 0.0, -19.75))
        self.AddHazard(self.block2)
        prism = self.AddPrismatic("arena_collision", "step03", 0, 1, 0, 1.0, -30.0, 0)
        self.block3 = TestHaz.Faller(prism, (0.0, 0.0, -20))
        self.AddHazard(self.block3)
        prism = self.AddPrismatic("arena_collision", "step04", 0, 1, 0, 1.0, -30.0, 0)
        self.block4 = TestHaz.Faller(prism, (0.0, 0.0, -20.25))
        self.AddHazard(self.block4)
        prism = self.AddPrismatic("arena_collision", "step05", 0, 1, 0, 1.0, -30.0, 0)
        self.block5 = TestHaz.Faller(prism, (0.0, 0.0, -20.5))
        self.AddHazard(self.block5)
        prism = self.AddPrismatic("arena_collision", "step06", 0, 1, 0, 1.0, -30.0, 0)
        self.block6 = TestHaz.Faller(prism, (0.0, 0.0, -20.75))
        self.AddHazard(self.block6)
        prism = self.AddPrismatic("arena_collision", "step07", 0, 1, 0, 1.0, -30.0, 0)
        self.block7 = TestHaz.Faller(prism, (0.0, 0.0, -21))
        self.AddHazard(self.block7)
        prism = self.AddPrismatic("arena_collision", "step08", 0, 1, 0, 1.0, -30.0, 0)
        self.block8 = TestHaz.Faller(prism, (0.0, 0.0, -21.25))
        self.AddHazard(self.block8)
        prism = self.AddPrismatic("arena_collision", "step09", 0, 1, 0, 1.0, -30.0, 0)
        self.block9 = TestHaz.Faller(prism, (0.0, 0.0, -21.5))
        self.AddHazard(self.block9)
        prism = self.AddPrismatic("arena_collision", "step10", 0, 1, 0, 1.0, -30.0, 0)
        self.block10 = TestHaz.Faller(prism, (0.0, 0.0, -21.75))
        self.AddHazard(self.block10)
        prism = self.AddPrismatic("arena_collision", "step11", 0, 1, 0, 1.0, -30.0, 0)
        self.block11 = TestHaz.Faller(prism, (0.0, 0.0, -22))
        self.AddHazard(self.block11)
        prism = self.AddPrismatic("arena_collision", "step12", 0, 1, 0, 1.0, -30.0, 0)
        self.block12 = TestHaz.Faller(prism, (0.0, 0.0, -22.25))
        self.AddHazard(self.block12)
        prism = self.AddPrismatic("arena_collision", "step13", 0, 1, 0, 1.0, -30.0, 0)
        self.block13 = TestHaz.Faller(prism, (0.0, 0.0, -22.5))
        self.AddHazard(self.block13)
        prism = self.AddPrismatic("arena_collision", "step14", 0, 1, 0, 1.0, -30.0, 0)
        self.block14 = TestHaz.Faller(prism, (0.0, 0.0, -22.75))
        self.AddHazard(self.block14)
        prism = self.AddPrismatic("arena_collision", "step15", 0, 1, 0, 1.0, -30.0, 0)
        self.block15 = TestHaz.Faller(prism, (0.0, 0.0, -23.0))
        self.AddHazard(self.block15)
        prism = self.AddPrismatic("arena_collision", "step16", 0, 1, 0, 1.0, -30.0, 0)
        self.block16 = TestHaz.Faller(prism, (0.0, 0.0, -23.25))
        self.AddHazard(self.block16)
        prism = self.AddPrismatic("arena_collision", "step17", 0, 1, 0, 1.0, -30.0, 0)
        self.block17 = TestHaz.Faller(prism, (0.0, 0.0, -23.5))
        self.AddHazard(self.block17)
        prism = self.AddPrismatic("arena_collision", "step18", 0, 1, 0, 1.0, -30.0, 0)
        self.block18 = TestHaz.Faller(prism, (0.0, 0.0, -23.75))
        self.AddHazard(self.block18)
        prism = self.AddPrismatic("arena_collision", "step19", 0, 1, 0, 1.0, -30.0, 0)
        self.block19 = TestHaz.Faller(prism, (0.0, 0.0, -24.0))
        self.AddHazard(self.block19)
        prism = self.AddPrismatic("arena_collision", "step20", 0, 1, 0, 1.0, -30.0, 0)
        self.block20 = TestHaz.Faller(prism, (0.0, 0.0, -24.25))
        self.AddHazard(self.block20)
        prism = self.AddPrismatic("arena_collision", "step21", 0, 1, 0, 1.0, -30.0, 0)
        self.block21 = TestHaz.Faller(prism, (0.0, 0.0, -24.5))
        self.AddHazard(self.block21)
        prism = self.AddPrismatic("arena_collision", "step22", 0, 1, 0, 1.0, -30.0, 0)
        self.block22 = TestHaz.Faller(prism, (0.0, 0.0, -24.75))
        self.AddHazard(self.block22)
        prism = self.AddPrismatic("arena_collision", "step23", 0, 1, 0, 1.0, -30.0, 0)
        self.block23 = TestHaz.Faller(prism, (0.0, 0.0, -25))
        self.AddHazard(self.block23)

	self.AddPrismatic("arena_collision", "island", 0, 1, 0, 0, 0, 1)
	return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)



    def Tick(self):
	self.platimer +=0.25
	if self.platimer == 10:
	    self.block1.Fall(1)
	elif self.platimer == 20:
	    self.block2.Fall(1)
	elif self.platimer == 30:
	    self.block3.Fall(1)
	elif self.platimer == 40:
	    self.block4.Fall(1)
	elif self.platimer == 50:
	    self.block5.Fall(1)
	elif self.platimer == 60:
	    self.block6.Fall(1)
	elif self.platimer == 70:
	    self.block7.Fall(1)
	elif self.platimer == 80:
	    self.block8.Fall(1)
	elif self.platimer == 90:
	    self.block9.Fall(1)
	elif self.platimer == 100:
	    self.block10.Fall(1)
	elif self.platimer == 110:
	    self.block11.Fall(1)
	elif self.platimer == 120:
	    self.block12.Fall(1)
	elif self.platimer == 130:
	    self.block13.Fall(1)
	elif self.platimer == 140:
	    self.block14.Fall(1)
	elif self.platimer == 150:
	    self.block15.Fall(1)
	elif self.platimer == 160:
	    self.block16.Fall(1)
	elif self.platimer == 170:
	    self.block17.Fall(1)
	elif self.platimer == 180:
	    self.block18.Fall(1)
	elif self.platimer == 190:
	    self.block19.Fall(1)
	elif self.platimer == 200:
	    self.block20.Fall(1)
	elif self.platimer == 210:
	    self.block21.Fall(1)
	elif self.platimer == 220:
	    self.block22.Fall(1)
	elif self.platimer == 230:
	    self.block23.Fall(1)

        # check to see if anyone has been "eliminated" by falling off the tabletop
        for each in self.players:
            if plus.getLocation(each)[1] < 8:
                plus.eliminatePlayer(each)
 


        return Arenas.SuperArena.Tick(self)
        
Arenas.register(BoxArena)
